IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_DESCONTO_RESSUP]') AND type in (N'FN'))
DROP FUNCTION [dbo].[UFD_EST_PROD_DESCONTO_RESSUP]
GO  
  

/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_DESCONTO_RESSUP]    Script Date: 08/08/2012 11:38:20 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

 
CREATE FUNCTION [dbo].[UFD_EST_PROD_DESCONTO_RESSUP] (@CD_EMP INT, 
									 @CD_PROD INT, 
									 @CD_GRP_ECON INT) 
	RETURNS MONEY AS 
BEGIN
	DECLARE @PERC_DESC MONEY
	DECLARE @PERC_MARGEM MONEY
	DECLARE @CTR_PMC INT
	DECLARE @TIPO INT
	DECLARE @FLAG_IGNORAR_CTR_PMC INT

	SELECT     
		@TIPO = pl.TIPO,
		@PERC_MARGEM = pl.PERC_MARGEM,
		@PERC_DESC = pl.PERC_DESC, 
		@FLAG_IGNORAR_CTR_PMC = pl.FLAG_IGNORAR_CTR_PMC,
		@CTR_PMC = p.CTR_PMC
	FROM         
		EST_ARV_MERC_LINHA_DESC_LISTA pl
		INNER JOIN (SELECT     
						EST_PROD.CD_EMP, 
						EST_PROD.CD_PROD, 
						EST_PROD.LISTA_PROD, 
						EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA, 
						EST_PROD.CTR_PMC
					FROM         
						EST_PROD INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 
						EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND 
						EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
					WHERE
						EST_PROD.CD_EMP = @CD_EMP
						AND EST_PROD.CD_PROD = @CD_PROD) p ON
		pl.CD_EMP = p.CD_EMP AND
		pl.CD_ARV_MERC_LINHA = p.CD_ARV_MERC_LINHA AND
		pl.LISTA_PROD = p.LISTA_PROD
	WHERE
		pl.CD_GRP_ECON = @CD_GRP_ECON

	RETURN ISNULL( @PERC_DESC,0)
END






GO


